@extends('admin.layouts.app')

@section('content')
<div class="container-fluid">
    <div class="card shadow-sm border-0">
        <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
            <h5 class="mb-0 text-gray-800 fw-bold">Edit Menu</h5>
            <a href="{{ route('admin.menus.index') }}" class="btn btn-secondary btn-sm">
                <i class="bi bi-arrow-left me-1"></i> Back
            </a>
        </div>
        <div class="card-body p-4">
            <form action="{{ route('admin.menus.update', $menu->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="title" class="form-label">Title</label>
                        <input type="text" class="form-control" id="title" name="title" value="{{ $menu->title }}" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="route" class="form-label">Route</label>
                        <input type="text" class="form-control" id="route" name="route" value="{{ $menu->route }}">
                        <small class="text-muted">Enter route name (e.g. admin.dashboard) or leave empty.</small>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="icon" class="form-label">Icon</label>
                        <input type="text" class="form-control" id="icon" name="icon" value="{{ $menu->icon }}">
                        <small class="text-muted">Bootstrap Icons class (e.g. bi bi-speedometer2)</small>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="parent_id" class="form-label">Parent Menu</label>
                        <select class="form-control" id="parent_id" name="parent_id">
                            <option value="">None</option>
                            @foreach($parents as $parent)
                                <option value="{{ $parent->id }}" {{ $menu->parent_id == $parent->id ? 'selected' : '' }}>{{ $parent->title }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="order" class="form-label">Order</label>
                        <input type="number" class="form-control" id="order" name="order" value="{{ $menu->order }}">
                    </div>
                </div>

                <div class="mt-4 d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.menus.index') }}" class="btn btn-light">Cancel</a>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-save me-1"></i> Update Menu
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
