<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e(\App\Models\Setting::get('browser_title', \App\Models\Setting::get('app_name', config('app.name')))); ?></title>
    <?php if(\App\Models\Setting::get('favicon')): ?>
        <link rel="icon" type="image/x-icon" href="<?php echo e(asset('storage/' . \App\Models\Setting::get('favicon'))); ?>">
    <?php endif; ?>
    <?php echo $__env->make('admin.layouts.styles', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</head>
<body class="bg-light">
<div id="global-loader" class="position-fixed top-0 start-0 w-100 h-100 bg-white d-flex justify-content-center align-items-center" style="z-index: 9999;">
    <div class="spinner-border text-primary" role="status" style="width: 3rem; height: 3rem;">
        <span class="visually-hidden">Loading...</span>
    </div>
</div>
<script>
    function hideLoader() {
        const loader = document.getElementById('global-loader');
        if (loader) {
            loader.style.transition = 'opacity 0.5s ease';
            loader.style.opacity = '0';
            loader.style.pointerEvents = 'none';
            setTimeout(() => {
                loader.style.display = 'none';
            }, 500);
        }
    }

    window.addEventListener('load', hideLoader);
    
    // Fallback if load event doesn't fire or takes too long
    setTimeout(hideLoader, 3000); 
</script>
<div class="d-flex" id="wrapper">
    <?php echo $__env->make('admin.layouts.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    
    <div id="page-content-wrapper" class="w-100">
        <?php echo $__env->make('admin.layouts.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <main class="p-4">
            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const sidebarToggle = document.getElementById('sidebarToggle');
        if (sidebarToggle) {
            sidebarToggle.addEventListener('click', function (event) {
                event.preventDefault();
                document.getElementById('wrapper').classList.toggle('toggled');
            });
        }
    });
</script>
<?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\Users\Ahad\Desktop\P\turning point\turning_point_live_exam\resources\views/admin/layouts/app.blade.php ENDPATH**/ ?>