

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Edit Exam</h1>
        </div>

        <div class="card shadow mb-4">
            <div class="card-body">
                <form action="<?php echo e(route('admin.exams.update', $exam->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="title" class="form-label">Exam Title</label>
                            <input type="text" class="form-control" id="title" name="title"
                                value="<?php echo e(old('title', $exam->title)); ?>" required>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label for="duration_minutes" class="form-label">Duration (minutes)</label>
                            <input type="number" class="form-control" id="duration_minutes" name="duration_minutes"
                                value="<?php echo e(old('duration_minutes', $exam->duration_minutes)); ?>" required>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label for="total_marks" class="form-label">Total Marks</label>
                            <input type="number" class="form-control" id="total_marks" name="total_marks"
                                value="<?php echo e(old('total_marks', $exam->total_marks)); ?>" required>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="start_time" class="form-label">Start Time</label>
                            <input type="datetime-local" class="form-control" id="start_time" name="start_time"
                                value="<?php echo e(old('start_time', $exam->start_time->format('Y-m-d\TH:i'))); ?>" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="end_time" class="form-label">End Time</label>
                            <input type="datetime-local" class="form-control" id="end_time" name="end_time"
                                value="<?php echo e(old('end_time', $exam->end_time->format('Y-m-d\TH:i'))); ?>" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-control" id="status" name="status">
                                <option value="DRAFT" <?php echo e($exam->status == 'DRAFT' ? 'selected' : ''); ?>>Draft</option>
                                <option value="PUBLISHED" <?php echo e($exam->status == 'PUBLISHED' ? 'selected' : ''); ?>>Published
                                </option>
                                <option value="COMPLETED" <?php echo e($exam->status == 'COMPLETED' ? 'selected' : ''); ?>>Completed
                                </option>
                            </select>
                        </div>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="negative_marking" name="negative_marking"
                                value="1" <?php echo e(old('negative_marking', $exam->negative_marking) ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="negative_marking">
                                Enable Negative Marking
                            </label>
                        </div>
                    </div>

                    <hr>
                    <h5>Question Generation Rules</h5>

                    <div id="rules-container">
                        <?php $__currentLoopData = $exam->rules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $rule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="row g-2 mb-2 rule-row">
                                <div class="col-md-4">
                                    <select class="form-control" name="rules[<?php echo e($index); ?>][subject_id]" required>
                                        <option value="">Select Subject</option>
                                        <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($subject->id); ?>" <?php echo e($rule->subject_id == $subject->id ? 'selected' : ''); ?>><?php echo e($subject->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <input type="number" class="form-control" name="rules[<?php echo e($index); ?>][easy]"
                                        placeholder="Easy Qty" value="<?php echo e($rule->easy); ?>" min="0" required>
                                </div>
                                <div class="col-md-2">
                                    <input type="number" class="form-control" name="rules[<?php echo e($index); ?>][medium]"
                                        placeholder="Med Qty" value="<?php echo e($rule->medium); ?>" min="0" required>
                                </div>
                                <div class="col-md-2">
                                    <input type="number" class="form-control" name="rules[<?php echo e($index); ?>][hard]"
                                        placeholder="Hard Qty" value="<?php echo e($rule->hard); ?>" min="0" required>
                                </div>
                                <div class="col-md-2">
                                    <button class="btn btn-outline-danger w-100 remove-rule" type="button">Remove</button>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <button type="button" class="btn btn-secondary btn-sm mb-3" id="add-rule">Add Rule</button>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary">Update Exam</button>
                        <a href="<?php echo e(route('admin.exams.index')); ?>" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                const container = document.getElementById('rules-container');
                const addButton = document.getElementById('add-rule');
                let ruleCount = <?php echo e($exam->rules->count()); ?>;
                if (ruleCount < 1) ruleCount = 0;

                // Ensure unique keys for new additions by using timestamp or smart increment
                // But simply appending with new unique indices works.
                let nextIndex = ruleCount + 1000;

                addButton.addEventListener('click', function () {
                    const index = nextIndex++;
                    const div = document.createElement('div');
                    div.className = 'row g-2 mb-2 rule-row';
                    div.innerHTML = `
                        <div class="col-md-4">
                            <select class="form-control" name="rules[${index}][subject_id]" required>
                                <option value="">Select Subject</option>
                                <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($subject->id); ?>"><?php echo e($subject->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <input type="number" class="form-control" name="rules[${index}][easy]" placeholder="Easy Qty" min="0" required>
                        </div>
                        <div class="col-md-2">
                            <input type="number" class="form-control" name="rules[${index}][medium]" placeholder="Med Qty" min="0" required>
                        </div>
                        <div class="col-md-2">
                                <input type="number" class="form-control" name="rules[${index}][hard]" placeholder="Hard Qty" min="0" required>
                        </div>
                            <div class="col-md-2">
                            <button class="btn btn-outline-danger w-100 remove-rule" type="button">Remove</button>
                        </div>
                    `;
                    container.appendChild(div);
                });

                container.addEventListener('click', function (e) {
                    if (e.target.classList.contains('remove-rule')) {
                        if (container.children.length > 1) {
                            e.target.closest('.rule-row').remove();
                        } else {
                            alert('At least one rule is required.');
                        }
                    }
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Ahad\Desktop\P\turning point\turning_point_live_exam\resources\views/admin/exams/edit.blade.php ENDPATH**/ ?>