

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0 text-gray-800">Questions</h1>
            <a href="<?php echo e(route('admin.questions.create')); ?>" class="btn btn-primary">Add New Question</a>
        </div>

        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <div class="card shadow mb-4">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Question</th>
                                <th>Subject / Topic</th>
                                <th>Type</th>
                                <th>Difficulty</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($question->id); ?></td>
                                    <td><?php echo e(Str::limit($question->question_text, 50)); ?></td>
                                    <td>
                                        <?php echo e($question->subject->name); ?> <br>
                                        <small class="text-muted"><?php echo e($question->topic->name ?? 'No Topic'); ?></small>
                                    </td>
                                    <td><?php echo e($question->question_type); ?></td>
                                    <td>
                                        <?php if($question->difficulty == 'EASY'): ?>
                                            <span class="badge bg-success">Easy</span>
                                        <?php elseif($question->difficulty == 'MEDIUM'): ?>
                                            <span class="badge bg-warning text-dark">Medium</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">Hard</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('admin.questions.edit', $question->id)); ?>"
                                            class="btn btn-sm btn-info">Edit</a>
                                        <form action="<?php echo e(route('admin.questions.destroy', $question->id)); ?>" method="POST"
                                            class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-danger"
                                                onclick="return confirm('Are you sure?')">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center">No questions found.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php echo e($questions->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Ahad\Desktop\P\turning point\turning_point_live_exam\resources\views/admin/questions/index.blade.php ENDPATH**/ ?>