

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0 text-gray-800">Assign Exam: <?php echo e($exam->title); ?></h1>
            <a href="<?php echo e(route('admin.exams.index')); ?>" class="btn btn-secondary">Back</a>
        </div>

        <div class="card shadow mb-4">
            <div class="card-body">
                <form action="<?php echo e(route('admin.exams.storeAssignment', $exam->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>

                    <div class="mb-4">
                        <label class="form-label fw-bold">Access Mode</label>
                        <select name="access_mode" id="access_mode" class="form-select" onchange="toggleStudentList()">
                            <option value="PUBLIC" <?php echo e($exam->access_mode == 'PUBLIC' ? 'selected' : ''); ?>>Public (Open to All)
                            </option>
                            <option value="PRIVATE" <?php echo e($exam->access_mode == 'PRIVATE' ? 'selected' : ''); ?>>Private (Assigned
                                Students Only)</option>
                        </select>
                        <div class="form-text">Public exams are visible to all students. Private exams are only visible to
                            selected students.</div>
                    </div>

                    <div id="student-list" class="<?php echo e($exam->access_mode == 'PUBLIC' ? 'd-none' : ''); ?>">
                        <h5 class="mb-3">Select Students</h5>
                        <div class="table-responsive" style="max-height: 400px; overflow-y: auto;">
                            <table class="table table-bordered table-sm">
                                <thead>
                                    <tr>
                                        <th width="50"><input type="checkbox" id="select-all"></th>
                                        <th>Name</th>
                                        <th>Email</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="text-center">
                                                <input type="checkbox" name="user_ids[]" value="<?php echo e($student->id); ?>"
                                                    class="student-checkbox" <?php echo e(in_array($student->id, $assignedUserIds) ? 'checked' : ''); ?>>
                                            </td>
                                            <td><?php echo e($student->name); ?></td>
                                            <td><?php echo e($student->email); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary">Save Assignment</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script>
            function toggleStudentList() {
                const mode = document.getElementById('access_mode').value;
                const list = document.getElementById('student-list');
                if (mode === 'PRIVATE') {
                    list.classList.remove('d-none');
                } else {
                    list.classList.add('d-none');
                }
            }

            document.getElementById('select-all').addEventListener('change', function (e) {
                document.querySelectorAll('.student-checkbox').forEach(cb => cb.checked = e.target.checked);
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Ahad\Desktop\P\turning point\turning_point_live_exam\resources\views/admin/exams/assign.blade.php ENDPATH**/ ?>