<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-md-12">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 text-gray-800 fw-bold">Menu Builder</h5>
                    <div>
                        <button id="saveOrder" class="btn btn-success btn-sm me-2" style="display: none;">
                            <i class="bi bi-check-lg me-1"></i> Save Order
                        </button>
                        <a href="<?php echo e(route('admin.menus.create')); ?>" class="btn btn-primary btn-sm">
                            <i class="bi bi-plus-lg me-1"></i> Add New Menu
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="dd" id="menu-nestable">
                        <ol class="dd-list">
                            <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo $__env->make('admin.menus.item', ['menu' => $menu], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/nestable2/1.6.0/jquery.nestable.min.css" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/nestable2/1.6.0/jquery.nestable.min.js"></script>
<style>
    .dd { max-width: 100%; }
    .dd-handle { 
        height: auto; 
        padding: 10px 15px; 
        border: 1px solid #e5e7eb; 
        background: #fff; 
        border-radius: 4px; 
        margin-bottom: 10px;
        cursor: move;
    }
    .dd-handle:hover { background: #f8f9fa; }
    .dd-item > button { margin-top: 8px; }
    .dd-placeholder { border: 1px dashed #ccc; background: #f8f9fa; }
</style>
<script>
    $(document).ready(function() {
        $('#menu-nestable').nestable({
            maxDepth: 5
        }).on('change', function() {
            $('#saveOrder').fadeIn();
        });

        $('#saveOrder').click(function() {
            var serializedData = $('#menu-nestable').nestable('serialize');
            
            $.ajax({
                url: "<?php echo e(route('admin.menus.order')); ?>",
                method: "POST",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    order: serializedData
                },
                success: function(response) {
                    $('#saveOrder').fadeOut();
                    alert('Menu order saved successfully!');
                },
                error: function() {
                    alert('Error saving menu order.');
                }
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Ahad\Desktop\P\turning point\turning_point_live_exam\resources\views/admin/menus/index.blade.php ENDPATH**/ ?>