<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Theme Settings</h1>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <form action="<?php echo e(route('admin.theme.update')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        
        
        <div class="card shadow mb-4">
                    <div class="card-header bg-white py-3">
                <h6 class="m-0 font-weight-bold text-primary">Theme Presets</h6>
                <button type="button" class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#savePresetModal">
                    <i class="bi bi-save me-1"></i> Save Current as Preset
                </button>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php $__currentLoopData = $presets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $preset): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $isActive = isset($activePresetId) && (int)$activePresetId === (int)$preset->id;
                        ?>
                        <div class="col-md-4 mb-3">
                            <!-- Debug: Active=<?php echo e($activePresetId); ?> Preset=<?php echo e($preset->id); ?> -->
                            <div class="card h-100 <?php echo e($isActive ? 'border-success shadow' : ($preset->is_default ? 'border-primary' : 'border-secondary')); ?>">
                                <div class="card-header <?php echo e($isActive ? 'bg-success text-white' : ''); ?>">
                                    <h5 class="card-title mb-0">
                                        <?php echo e($preset->name); ?>

                                        <?php if($isActive): ?>
                                            <i class="bi bi-check-circle-fill ms-2"></i>
                                        <?php endif; ?>
                                    </h5>
                                </div>
                                <div class="card-body text-center">
                                    <?php if($preset->is_default): ?>
                                        <span class="badge <?php echo e($isActive ? 'bg-light text-success' : 'bg-primary'); ?> mb-2">Default</span>
                                    <?php else: ?>
                                        <span class="badge <?php echo e($isActive ? 'bg-light text-success' : 'bg-secondary'); ?> mb-2">Custom</span>
                                    <?php endif; ?>
                                    <div class="d-grid gap-2">
                                        <form action="<?php echo e(route('admin.theme.apply')); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="preset_id" value="<?php echo e($preset->id); ?>">
                                            <button type="submit" class="btn <?php echo e($isActive ? 'btn-light text-success fw-bold' : 'btn-outline-primary'); ?> btn-sm w-100" <?php echo e($isActive ? 'disabled' : ''); ?>>
                                                <?php echo e($isActive ? 'Active' : 'Apply'); ?>

                                            </button>
                                        </form>
                                        <?php if(!$preset->is_default): ?>
                                            <div class="btn-group w-100">
                                                <a href="<?php echo e(route('admin.theme.preset.edit', $preset->id)); ?>" class="btn btn-outline-warning btn-sm w-50">
                                                    <i class="bi bi-pencil"></i> Edit
                                                </a>
                                                <form action="<?php echo e(route('admin.theme.preset.destroy', $preset->id)); ?>" method="POST" onsubmit="return confirm('Are you sure?');" class="w-50">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-outline-danger btn-sm w-100">
                                                        <i class="bi bi-trash"></i> Delete
                                                    </button>
                                                </form>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

        <div class="row">
            
            <div class="col-md-6 mb-4">
                <div class="card shadow">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">General Colors</h6>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Primary Color</label>
                            <div class="input-group">
                                <span class="input-group-text p-1">
                                    <input type="color" class="form-control form-control-color border-0 p-0" value="<?php echo e($settings['primary_color'] ?? '#4f46e5'); ?>" oninput="this.parentElement.nextElementSibling.value = this.value">
                                </span>
                                <input type="text" class="form-control" name="primary_color" value="<?php echo e($settings['primary_color'] ?? '#4f46e5'); ?>">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Danger Color</label>
                            <div class="input-group">
                                <span class="input-group-text p-1">
                                    <input type="color" class="form-control form-control-color border-0 p-0" value="<?php echo e($settings['danger_color'] ?? '#dc3545'); ?>" oninput="this.parentElement.nextElementSibling.value = this.value">
                                </span>
                                <input type="text" class="form-control" name="danger_color" value="<?php echo e($settings['danger_color'] ?? '#dc3545'); ?>">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Body Text Color</label>
                            <div class="input-group">
                                <span class="input-group-text p-1">
                                    <input type="color" class="form-control form-control-color border-0 p-0" value="<?php echo e($settings['body_text_color'] ?? '#212529'); ?>" oninput="this.parentElement.nextElementSibling.value = this.value">
                                </span>
                                <input type="text" class="form-control" name="body_text_color" value="<?php echo e($settings['body_text_color'] ?? '#212529'); ?>">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Body Background Color</label>
                            <div class="input-group">
                                <span class="input-group-text p-1">
                                    <input type="color" class="form-control form-control-color border-0 p-0" value="<?php echo e($settings['body_bg_color'] ?? '#f8f9fa'); ?>" oninput="this.parentElement.nextElementSibling.value = this.value">
                                </span>
                                <input type="text" class="form-control" name="body_bg_color" value="<?php echo e($settings['body_bg_color'] ?? '#f8f9fa'); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="col-md-6 mb-4">
                <div class="card shadow">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Navbar Settings</h6>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Navbar Background</label>
                            <div class="input-group">
                                <span class="input-group-text p-1">
                                    <input type="color" class="form-control form-control-color border-0 p-0" value="<?php echo e($settings['navbar_bg'] ?? '#ffffff'); ?>" oninput="this.parentElement.nextElementSibling.value = this.value">
                                </span>
                                <input type="text" class="form-control" name="navbar_bg" value="<?php echo e($settings['navbar_bg'] ?? '#ffffff'); ?>">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Navbar Text Color</label>
                            <div class="input-group">
                                <span class="input-group-text p-1">
                                    <input type="color" class="form-control form-control-color border-0 p-0" value="<?php echo e($settings['navbar_text_color'] ?? '#212529'); ?>" oninput="this.parentElement.nextElementSibling.value = this.value">
                                </span>
                                <input type="text" class="form-control" name="navbar_text_color" value="<?php echo e($settings['navbar_text_color'] ?? '#212529'); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="col-md-6 mb-4">
                <div class="card shadow">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Sidebar Settings</h6>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Sidebar Background</label>
                            <div class="input-group">
                                <span class="input-group-text p-1">
                                    <input type="color" class="form-control form-control-color border-0 p-0" value="<?php echo e($settings['sidebar_bg'] ?? '#111827'); ?>" oninput="this.parentElement.nextElementSibling.value = this.value">
                                </span>
                                <input type="text" class="form-control" name="sidebar_bg" value="<?php echo e($settings['sidebar_bg'] ?? '#111827'); ?>">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Sidebar Text Color</label>
                            <div class="input-group">
                                <span class="input-group-text p-1">
                                    <input type="color" class="form-control form-control-color border-0 p-0" value="<?php echo e($settings['sidebar_text_color'] ?? '#9ca3af'); ?>" oninput="this.parentElement.nextElementSibling.value = this.value">
                                </span>
                                <input type="text" class="form-control" name="sidebar_text_color" value="<?php echo e($settings['sidebar_text_color'] ?? '#9ca3af'); ?>">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Active Menu Background</label>
                            <div class="input-group">
                                <span class="input-group-text p-1">
                                    <input type="color" class="form-control form-control-color border-0 p-0" value="<?php echo e($settings['active_menu_bg'] ?? '#ffffff'); ?>" oninput="this.parentElement.nextElementSibling.value = this.value">
                                </span>
                                <input type="text" class="form-control" name="active_menu_bg" value="<?php echo e($settings['active_menu_bg'] ?? 'rgba(255,255,255,0.1)'); ?>">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Hover Menu Background</label>
                            <div class="input-group">
                                <span class="input-group-text p-1">
                                    <input type="color" class="form-control form-control-color border-0 p-0" value="<?php echo e($settings['hover_menu_bg'] ?? '#ffffff'); ?>" oninput="this.parentElement.nextElementSibling.value = this.value">
                                </span>
                                <input type="text" class="form-control" name="hover_menu_bg" value="<?php echo e($settings['hover_menu_bg'] ?? 'rgba(255,255,255,0.1)'); ?>">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Active/Hover Text Color</label>
                            <div class="input-group">
                                <span class="input-group-text p-1">
                                    <input type="color" class="form-control form-control-color border-0 p-0" value="<?php echo e($settings['active_menu_text_color'] ?? '#ffffff'); ?>" oninput="this.parentElement.nextElementSibling.value = this.value">
                                </span>
                                <input type="text" class="form-control" name="active_menu_text_color" value="<?php echo e($settings['active_menu_text_color'] ?? '#ffffff'); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="col-md-6 mb-4">
                <div class="card shadow">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Component Colors</h6>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Card Background</label>
                            <div class="input-group">
                                <span class="input-group-text p-1">
                                    <input type="color" class="form-control form-control-color border-0 p-0" value="<?php echo e($settings['card_bg'] ?? '#ffffff'); ?>" oninput="this.parentElement.nextElementSibling.value = this.value">
                                </span>
                                <input type="text" class="form-control" name="card_bg" value="<?php echo e($settings['card_bg'] ?? '#ffffff'); ?>">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Table Header Background</label>
                            <div class="input-group">
                                <span class="input-group-text p-1">
                                    <input type="color" class="form-control form-control-color border-0 p-0" value="<?php echo e($settings['table_header_bg'] ?? '#f8f9fa'); ?>" oninput="this.parentElement.nextElementSibling.value = this.value">
                                </span>
                                <input type="text" class="form-control" name="table_header_bg" value="<?php echo e($settings['table_header_bg'] ?? '#f8f9fa'); ?>">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Table Header Text Color</label>
                            <div class="input-group">
                                <span class="input-group-text p-1">
                                    <input type="color" class="form-control form-control-color border-0 p-0" value="<?php echo e($settings['table_header_text_color'] ?? '#212529'); ?>" oninput="this.parentElement.nextElementSibling.value = this.value">
                                </span>
                                <input type="text" class="form-control" name="table_header_text_color" value="<?php echo e($settings['table_header_text_color'] ?? '#212529'); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="col-md-6 mb-4">
                <div class="card shadow">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Typography</h6>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Table Font Size (px)</label>
                            <input type="number" class="form-control" name="table_font_size" value="<?php echo e($settings['table_font_size'] ?? '16'); ?>">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="d-grid gap-2 d-md-flex justify-content-md-end mb-4">
            <button type="submit" class="btn btn-primary btn-lg"><i class="bi bi-save me-2"></i>Save Settings</button>
        </div>
    </form>
</div>

<!-- Save Preset Modal -->
<div class="modal fade" id="savePresetModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <form action="<?php echo e(route('admin.theme.preset.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Save Current Theme as Preset</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="preset_name" class="form-label">Preset Name</label>
                        <input type="text" class="form-control" id="preset_name" name="name" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save Preset</button>
                </div>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Ahad\Desktop\P\turning point\turning_point_live_exam\resources\views/admin/theme/index.blade.php ENDPATH**/ ?>