

<?php $__env->startSection('content'); ?>
    <div class="container-fluid py-3">
        <div class="row g-4">
            <!-- Sidebar / Navigation -->
            <div class="col-lg-3 order-lg-last">
                <div class="card shadow-sm border-0 fixed-sidebar h-100">
                    <div class="card-header bg-primary text-white text-center py-3 rounded-top">
                        <h6 class="mb-1 opacity-75 text-uppercase letter-spacing-1">Time Remaining</h6>
                        <h2 id="timer" class="fw-bold mb-0 display-6">--:--</h2>
                    </div>
                    <div class="card-body">
                        <p class="text-muted small text-center mb-3">Question Navigator</p>
                        <div class="d-flex flex-wrap gap-2 justify-content-center">
                            <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <button type="button"
                                    class="btn btn-outline-light text-dark border-secondary btn-sm question-nav-btn position-relative"
                                    style="width: 45px; height: 45px;" id="nav-btn-<?php echo e($answer->question_id); ?>"
                                    data-qid="<?php echo e($answer->question_id); ?>"
                                    onclick="scrollToQuestion(<?php echo e($answer->question_id); ?>)">
                                    <?php echo e($index + 1); ?>

                                    <span
                                        class="position-absolute top-0 start-100 translate-middle p-1 bg-success border border-light rounded-circle d-none"
                                        id="status-dot-<?php echo e($answer->question_id); ?>">
                                        <span class="visually-hidden">Answered</span>
                                    </span>
                                </button>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <div class="mt-4 pt-3 border-top">
                            <div class="d-flex justify-content-between small text-muted mb-2">
                                <span><i class="fas fa-circle text-success me-1"></i> Answered</span>
                                <span><i class="fas fa-circle text-secondary me-1"></i> Pending</span>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer bg-white border-0 pb-4 pt-0">
                        <button type="button"
                            class="btn btn-danger w-100 py-2 fw-bold text-uppercase letter-spacing-1 shadow-sm"
                            onclick="confirmFinish()">
                            <i class="fas fa-flag-checkered me-2"></i> Finish Exam
                        </button>
                        <form action="<?php echo e(route('student.exams.finish', $attempt->id)); ?>" method="POST" id="finishForm"
                            class="d-none"><?php echo csrf_field(); ?></form>
                    </div>
                </div>
            </div>

            <!-- Question Area -->
            <div class="col-lg-9">
                <div class="card shadow-sm border-0 mb-4">
                    <div class="card-body p-4">
                        <h4 class="card-title fw-bold text-primary mb-1"><?php echo e($attempt->exam->title); ?></h4>
                        <p class="text-muted mb-0">Answer all questions. Auto-submission enabled when time expires.</p>
                    </div>
                </div>

                <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="card shadow-sm border-0 mb-4 question-block" id="question-<?php echo e($answer->question_id); ?>">
                        <div class="card-body p-4">
                            <div class="d-flex mb-3">
                                <div class="flex-shrink-0">
                                    <span class="badge bg-primary rounded-circle p-3 fs-5"
                                        style="width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;"><?php echo e($index + 1); ?></span>
                                </div>
                                <div class="flex-grow-1 ms-3 pt-1">
                                    <h5 class="fw-semibold text-dark mb-0 form-label"><?php echo e($answer->question->question_text); ?>

                                    </h5>
                                    <div class="mt-1">
                                        <span
                                            class="badge bg-light text-secondary border me-1"><?php echo e($answer->question->question_type == 'SINGLE' ? 'Single Choice' : 'Multiple Choice'); ?></span>
                                        <span class="badge bg-light text-secondary border">Marks: 1</span>
                                        <!-- Assuming 1 mark per q for now based on logic -->
                                    </div>
                                </div>
                            </div>

                            <div class="options-list ms-md-5 ps-md-3 border-start border-3 border-light">
                                <?php $__currentLoopData = $answer->question->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-check custom-option mb-3 p-3 rounded border position-relative">
                                        <input class="form-check-input stretched-link me-3" style="transform: scale(1.3);"
                                            type="<?php echo e($answer->question->question_type === 'SINGLE' ? 'radio' : 'checkbox'); ?>"
                                            name="q_<?php echo e($answer->question_id); ?><?php echo e($answer->question->question_type === 'MULTIPLE' ? '[]' : ''); ?>"
                                            value="<?php echo e($option->id); ?>" id="opt-<?php echo e($option->id); ?>"
                                            onchange="saveAnswer(<?php echo e($answer->question_id); ?>, '<?php echo e($answer->question->question_type); ?>')"
                                            <?php echo e((is_array($answer->selected_options) && in_array($option->id, $answer->selected_options)) ? 'checked' : ''); ?>>

                                        <label class="form-check-label w-100 cursor-pointer" for="opt-<?php echo e($option->id); ?>">
                                            <?php echo e($option->option_text); ?>

                                        </label>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    <style>
        .fixed-sidebar {
            position: sticky;
            top: 20px;
            transition: top 0.3s;
        }

        .custom-option {
            transition: all 0.2s ease;
            background-color: #fff;
        }

        .custom-option:hover {
            background-color: #f8f9fa;
            border-color: #dee2e6 !important;
        }

        .custom-option:has(.form-check-input:checked) {
            background-color: #fce4ec;
            border-color: #e53935 !important;
            color: #e53935;
            font-weight: 500;
        }

        .form-check-input:checked {
            background-color: #e53935;
            border-color: #e53935;
        }

        .question-nav-btn.btn-outline-light:hover {
            background-color: #e9ecef;
            color: #000;
        }

        .question-nav-btn.active-q {
            background-color: #e53935 !important;
            color: white !important;
            border-color: #e53935 !important;
        }

        .letter-spacing-1 {
            letter-spacing: 1px;
        }
    </style>

    <script>
        let remainingSeconds = <?php echo e($remainingSeconds); ?>;
        const attemptId = <?php echo e($attempt->id); ?>;
        const csrfToken = '<?php echo e(csrf_token()); ?>';

        function updateTimer() {
            if (remainingSeconds <= 0) {
                document.getElementById('timer').innerText = "00:00";
                document.getElementById('timer').classList.add('text-danger');
                finishExam();
                return;
            }

            let minutes = Math.floor(remainingSeconds / 60);
            let seconds = remainingSeconds % 60;
            document.getElementById('timer').innerText =
                (minutes < 10 ? "0" : "") + minutes + ":" + (seconds < 10 ? "0" : "") + seconds;

            if (remainingSeconds < 60) { // Last minute warning
                document.getElementById('timer').classList.add('text-warning');
            }

            remainingSeconds--;
        }

        setInterval(updateTimer, 1000);

        function scrollToQuestion(qid) {
            document.getElementById('question-' + qid).scrollIntoView({ behavior: 'smooth', block: 'center' });
        }

        function saveAnswer(questionId, type) {
            let selected = [];
            if (type === 'SINGLE') {
                const el = document.querySelector(`input[name="q_${questionId}"]:checked`);
                if (el) selected.push(el.value);
            } else {
                document.querySelectorAll(`input[name="q_${questionId}[]"]:checked`).forEach((el) => {
                    selected.push(el.value);
                });
            }

            // UI Feedback
            const navBtn = document.getElementById('nav-btn-' + questionId);
            const dot = document.getElementById('status-dot-' + questionId);

            if (selected.length > 0) {
                navBtn.classList.add('active-q');
                dot.classList.remove('d-none');
            } else {
                navBtn.classList.remove('active-q');
                dot.classList.add('d-none');
            }

            // AJAX Save
            fetch(`<?php echo e(url('/student/exam')); ?>/${attemptId}/submit`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken
                },
                body: JSON.stringify({
                    question_id: questionId,
                    selected_options: selected
                })
            }).catch(err => console.error('Save failed', err));
        }

        function confirmFinish() {
            if (confirm('Are you sure you want to submit your exam? This action cannot be undone.')) {
                finishExam();
            }
        }

        function finishExam() {
            document.getElementById('finishForm').submit();
        }

        document.addEventListener('DOMContentLoaded', () => {
            // Init state
            <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(!empty($answer->selected_options)): ?>
                    document.getElementById('nav-btn-<?php echo e($answer->question_id); ?>').classList.add('active-q');
                    document.getElementById('status-dot-<?php echo e($answer->question_id); ?>').classList.remove('d-none');
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Ahad\Desktop\P\turning point\turning_point_live_exam\resources\views/student/exams/live.blade.php ENDPATH**/ ?>