<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Exam extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'question_paper_id',
        'start_time',
        'end_time',
    ];

    protected $casts = [
        'start_time' => 'datetime',
        'end_time' => 'datetime',
    ];

    public function questionPaper()
    {
        return $this->belongsTo(QuestionPaper::class);
    }

    public function students()
    {
        return $this->belongsToMany(Student::class, 'exam_student');
    }
}