<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-12 col-lg-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <div class="header-title">
                    <h4 class="card-title">All Frontend Manager Courses</h4>
                </div>
                <div class="header-action">
                    <a href="<?php echo e(route('admin.frontend_manager_courses.create')); ?>" class="btn btn-primary">Add Course</a>
                </div>
            </div>
            <div class="card-body">
                <?php if(session('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Category</th>
                                <th>Image</th>
                                <th>Title</th>
                                <th>Real Amount</th>
                                <th>Discount Amount</th>
                                <th>Offer Expire Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($course->category->name ?? 'N/A'); ?></td>
                                    <td>
                                        <?php if($course->image): ?>
                                            <img src="<?php echo e(asset($course->image)); ?>" alt="<?php echo e($course->title); ?>" width="50">
                                        <?php else: ?>
                                            N/A
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($course->title); ?></td>
                                    <td><?php echo e($course->real_amount); ?></td>
                                    <td><?php echo e($course->discount_amount ?? 'N/A'); ?></td>
                                    <td><?php echo e($course->offer_expire_date ? \Carbon\Carbon::parse($course->offer_expire_date)->format('M d, Y') : 'N/A'); ?></td>
                                    <td>
                                        <div class="d-flex">
                                            <a href="<?php echo e(route('admin.frontend_manager_courses.edit', $course->id)); ?>" class="btn btn-sm btn-info mr-2">Edit</a>
                                            <form action="<?php echo e(route('admin.frontend_manager_courses.destroy', $course->id)); ?>" method="POST" onsubmit="return confirm('Are you sure?');">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\turningpoint\resources\views/admin/frontend_manager_courses/index.blade.php ENDPATH**/ ?>