<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <h2 class="section-title text-center"><?php echo e($branch->name); ?> - All Courses</h2>
    <div class="row">
        <?php $__empty_1 = true; $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="col-md-4 mb-4">
                <div class="card h-100 shadow-sm">
                    <img src="<?php echo e(asset($course->image)); ?>" class="card-img-top" alt="<?php echo e($course->title); ?>">
                    <div class="card-body">
                        <h5 class="card-title"><?php echo e($course->title); ?></h5>
                        <p class="card-text">Real Amount: <?php echo e($course->real_amount); ?></p>
                        <?php if($course->discount_amount): ?>
                            <p class="card-text">Discount: <?php echo e($course->discount_amount); ?></p>
                        <?php endif; ?>
                        <?php if($course->offer_expire_date): ?>
                            <p class="card-text">Expires: <?php echo e(\Carbon\Carbon::parse($course->offer_expire_date)->format('M d, Y')); ?></p>
                        <?php endif; ?>
                        <a href="<?php echo e(route('frontend.courses.show_detail', $course->id)); ?>" class="btn btn-primary mt-2">বিস্তারিত দেখুন</a>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-12 text-center">
                <p>No courses available for this branch.</p>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\turningpoint\resources\views/frontend/branch_courses/index.blade.php ENDPATH**/ ?>