<?php $__env->startSection('content'); ?>
    <?php
        use App\Models\Promotion;
        use App\Models\SiteSetting;
        use App\Models\ExpertInstructor;
        use App\Models\CourseOutline;
        use App\Models\DedicatedSupport;
        $promotions = Promotion::where('status', 1)->limit(2)->get();
        $siteSetting = SiteSetting::first();
        $expertInstructors = ExpertInstructor::all();
        $courseOutlines = CourseOutline::all();
        $dedicatedSupports = DedicatedSupport::all();
    ?>

    <section class="hero-section">
        <div class="container">
            <div class="row d-flex align-items-stretch justify-content-center">
                <?php $__empty_1 = true; $__currentLoopData = $branchesWithContent; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="col-md-5 mb-4">
                        <div class="branch-card h-100" style="border: 4px solid #e53935;text-align: center;border-radius: 10px;">
                            <a href="<?php echo e(route('frontend.branches.show_courses', $branch->slug)); ?>">
                                <img src="<?php echo e(asset($branch->logo)); ?>" alt="<?php echo e($branch->name); ?>" class="img-fluid" style="width: 70%;height: auto;">
                            </a>
                            <div style="padding: 10px 35px;"> 
                                <?php $__empty_2 = true; $__currentLoopData = $branch->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                    <a href="<?php echo e(route('frontend.categories.show_courses', $category->slug)); ?>" class="btn btn-primary btn-block category-button"><?php echo e($category->name); ?></a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                    <div class="col-12 text-center">
                                        <p>No categories available for <?php echo e($branch->name); ?>.</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="col-12 text-center">
                        <p>No branches available.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <?php if($siteSetting && $siteSetting->marquee_text): ?>
        <div class="marquee-container">
            <div class="marquee-text"><?php echo e($siteSetting->marquee_text); ?></div>
        </div>
    <?php endif; ?>

    <section class="why-choose-us bg-gray">
        <div class="container">
            <h2 class="section-title">Why Choose Us?</h2>
            <div class="row text-center">
                <div class="col-md-4 mb-4">
                    <div class="card h-100 shadow-sm" style="border: 3px solid #e53935;">
                        <div class="card-body">
                            <h5 class="card-title">Expert Instructors</h5>
                            <hr style="border-color: #e53935;">
                            <?php $__empty_1 = true; $__currentLoopData = $expertInstructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="d-flex align-items-center mb-3" style="box-shadow: 0px 0px 4px 3px #efefef;padding: 6px 16px;border-radius: 7px;">
                                <img src="<?php echo e(asset('images/expert_instructors/' . $instructor->image)); ?>" alt="<?php echo e($instructor->title); ?>" class="img-fluid rounded-circle mr-3" width="50">
                                <div class="text-left">
                                    <h6 style="width: 100px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;"><?php echo e($instructor->title); ?></h6>
                                    <a href="<?php echo e($instructor->youtube_link); ?>" target="_blank" class="btn btn-sm btn-primary mt-1">YouTube Link</a>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <p class="card-text">No expert instructors available yet. Please add some from the admin panel.</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="card h-100 shadow-sm" style="border: 3px solid #e53935;">
                        <div class="card-body">
                            <h5 class="card-title">Course Outlines</h5>
                            <hr style="border-color: #e53935;">
                            <?php $__empty_1 = true; $__currentLoopData = $courseOutlines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $outline): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="d-flex align-items-center mb-3" style="box-shadow: 0px 0px 4px 3px #efefef;padding: 6px 16px;border-radius: 7px;">
                                <i class="fas fa-file-pdf fa-2x text-primary mr-3"></i>
                                <div class="text-left">
                                    <h6 style="width: 100px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;"><?php echo e($outline->title); ?></h6>
                                    <a href="<?php echo e(asset($outline->pdf_path)); ?>" class="btn btn-sm btn-primary mt-1" target="_blank">Download PDF</a>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <p class="card-text">No course outlines available yet. Please add some from the admin panel.</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="card h-100 shadow-sm" style="border: 3px solid #e53935;">
                        <div class="card-body">
                            <h5 class="card-title">Dedicated Support</h5>
                            <hr style="border-color: #e53935;">
                            <?php $__empty_1 = true; $__currentLoopData = $dedicatedSupports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $support): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="d-flex align-items-center mb-3" style="box-shadow: 0px 0px 4px 3px #efefef;padding: 6px 16px;border-radius: 7px;">
                                <i class="fas fa-phone fa-2x text-primary mr-3"></i>
                                <div class="text-left">
                                    <h6 style="width: 100px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;"><?php echo e($support->title); ?></h6>
                                    <p class="card-text mb-0"><?php echo e($support->number); ?></p>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <p class="card-text">No dedicated support contacts available yet. Please add some from the admin panel.</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

     <section class="why-choose-us bg-gray p-0 ">
           <img src="<?php echo e(asset('images/directors.webp')); ?>" alt="" style="width: 100%;">
    </section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\turningpoint\resources\views/welcome.blade.php ENDPATH**/ ?>